#!/bin/bash
set -euo pipefail

# ======================================
# Environment variables
export CLASSPATH=.
LOG_LEVEL='-DAEONICS_MANAGER_LOGGER_LEVEL=800'
PLUGIN_DIR='-DAEONICS_PLUGIN_PATH=plugins'
ARGS=("$PLUGIN_DIR" "$LOG_LEVEL")
# ================================

# ======================================
# Check Java version
if ! command -v java >/dev/null 2>&1; then
  echo "[ERROR] Java not found or not executable. Please install Java 11 or higher."
  exit 1
fi

JVER="$(java -version 2>&1 | awk -F\" '/version/ {print $2; exit}')"
JMAJOR="${JVER%%.*}"
[[ "$JMAJOR" =~ ^[0-9]+$ ]] || JMAJOR=0

if (( JMAJOR < 11 )); then
  echo "[ERROR] Java version $JVER is too old. Aeonics requires 11 or higher."
  exit 1
fi

# ======================================
# Run
exec java "${ARGS[@]}" --module-path ae.jar --module aeonics.boot/aeonics.Boot