/*
 * Decompiled with CFR 0.152.
 */
package aeonics.manager.impl;

import aeonics.data.Data;
import aeonics.manager.Logger;
import aeonics.manager.Manager;
import aeonics.manager.Translator;
import aeonics.template.Parameter;
import aeonics.template.Template;
import aeonics.util.Hardware;
import aeonics.util.Json;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Map;
import java.util.function.Supplier;

public class DefaultTranslator
extends Manager<Translator> {
    protected Class<? extends Implementation> defaultTarget() {
        return Implementation.class;
    }

    protected Supplier<? extends Implementation> defaultCreator() {
        return () -> new Implementation();
    }

    public Template<? extends Translator> template() {
        return super.template().summary("Basic translator").description("This translator implementation will load translations from JSON files in the target language folder. Translation files are lazily loaded at first use only (or after being cleared). Manually set entries will be available but will not be persisted.").add(new Parameter("default").summary("Default language").description("The default language of the translator. It should be a ISO-639 (2 letter) language code.").format("text").optional(true).min(2).max(2).rule(Parameter.Rule.LOWER).defaultValue((Object)"en")).add(new Parameter("folder").summary("Resource folder").description("The name of the folder from which translations can be loaded. That folder should contain one subfolder per language.").format("text").optional(true).defaultValue((Object)"translations")).onCreate((data, translator) -> {
            if (!data.isEmpty("default")) {
                translator.language(data.asString("default"));
            }
        }).onUpdate((data, translator) -> {
            if (!data.isEmpty("default")) {
                translator.language(data.asString("default"));
            }
        });
    }

    private static class Implementation
    extends Translator {
        private String language = "en";
        private Data cache = Data.map();

        private Implementation() {
        }

        public void language(String string) {
            if (string == null || string.length() != 2) {
                string = "en";
            }
            if (!string.matches("^[a-z][a-z]$")) {
                throw new IllegalArgumentException("Invalid language");
            }
            this.language = string;
        }

        public String language() {
            return this.language;
        }

        public String get(String string, String string2) {
            if (string == null || string.isBlank()) {
                return "";
            }
            if (string2 == null || string2.length() != 2) {
                string2 = this.language();
            }
            if (!this.cache.containsKey(string2)) {
                this.preload(string2);
            }
            return this.cache.get("language").asString(string);
        }

        public void set(String string, String string2, String string3) {
            if (string == null || string.isBlank()) {
                return;
            }
            if (string3 == null || string3.length() != 2) {
                string3 = this.language();
            }
            if (!this.cache.containsKey(string3)) {
                this.preload(string3);
            }
            this.cache.get("language").put(string, (Object)string2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clear(String string) {
            if (string == null || string.length() != 2) {
                string = this.language();
            }
            Data data = this.cache;
            synchronized (data) {
                this.cache.remove(string);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clear() {
            Data data = this.cache;
            synchronized (data) {
                this.cache.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void preload(String string) {
            if (string == null || string.length() != 2) {
                string = this.language();
            }
            if (!string.matches("^[a-z][a-z]$")) {
                throw new IllegalArgumentException("Invalid language");
            }
            if (this.cache.containsKey(string)) {
                return;
            }
            Data data = this.cache;
            synchronized (data) {
                if (this.cache.containsKey(string)) {
                    return;
                }
                final Data data2 = Data.map();
                try {
                    Path path = Paths.get(this.valueOf("folder").asString() + File.separatorChar + string, new String[0]);
                    if (!path.toFile().isDirectory()) {
                        return;
                    }
                    Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                        @Override
                        public FileVisitResult visitFile(Path path, BasicFileAttributes basicFileAttributes) throws IOException {
                            if (!basicFileAttributes.isRegularFile() || !Files.isReadable(path)) {
                                return FileVisitResult.CONTINUE;
                            }
                            if (path.toString().endsWith(".json")) {
                                try {
                                    Hardware.RAM.waitForSpace((long)(basicFileAttributes.size() * 2L), (long)1000L);
                                    Data data = Json.decode((String)new String(Files.readAllBytes(path), StandardCharsets.UTF_8));
                                    if (!data.isMap()) {
                                        throw new Exception("Invalid translation file " + path.toString());
                                    }
                                    for (Map.Entry entry : data.entrySet()) {
                                        data2.put((String)entry.getKey(), (Object)((Data)entry.getValue()).asString());
                                    }
                                }
                                catch (Exception exception) {
                                    ((Logger)Manager.of(Logger.class)).info(Translator.class, (Throwable)exception);
                                }
                            }
                            return FileVisitResult.CONTINUE;
                        }
                    });
                }
                catch (Exception exception) {
                    ((Logger)Manager.of(Logger.class)).warning(Translator.class, (Throwable)exception);
                }
                finally {
                    this.cache.put(string, (Object)data2);
                }
            }
        }
    }
}

