/*
 * Decompiled with CFR 0.152.
 */
package aeonics.manager.impl;

import aeonics.Boot;
import aeonics.manager.Lifecycle;
import aeonics.manager.Logger;
import aeonics.manager.Manager;
import aeonics.template.Template;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.LockSupport;
import java.util.function.Supplier;

public class DefaultLifecycle
extends Manager<Lifecycle> {
    protected Class<? extends Implementation> defaultTarget() {
        return Implementation.class;
    }

    protected Supplier<? extends Implementation> defaultCreator() {
        return () -> new Implementation();
    }

    public Template<? extends Lifecycle> template() {
        return super.template().summary("Application Lifecycle").description("Manages the dispatching of application-wide lifecycle events.");
    }

    private static class Implementation
    extends Lifecycle {
        private AtomicReference<Lifecycle.Phase> current = new AtomicReference<Lifecycle.Phase>(Lifecycle.Phase.BOOT);

        private Implementation() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void boot() {
            if (Thread.currentThread() != Boot.MAIN) {
                throw new IllegalStateException("This method must be called from the main thread");
            }
            if (!this.current.compareAndSet(Lifecycle.Phase.BOOT, Lifecycle.Phase.LOAD)) {
                throw new IllegalStateException("This method cannot be called more than once");
            }
            this.start(Lifecycle.Phase.LOAD);
            this.start(Lifecycle.Phase.CONFIG);
            this.start(Lifecycle.Phase.RUN);
            System.gc();
            ((Logger)Manager.of(Logger.class)).info(Boot.class, "System boot-to-run in {}ms. Ready.", new Object[]{System.currentTimeMillis() - Boot.BOOT_TIME});
            AtomicBoolean atomicBoolean = new AtomicBoolean(false);
            Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                if (!atomicBoolean.get()) {
                    Boot.MAIN.interrupt();
                }
                while (!atomicBoolean.get()) {
                    LockSupport.parkNanos(1000L);
                }
            }));
            while (!Boot.MAIN.isInterrupted()) {
                try {
                    Thread thread = Boot.MAIN;
                    synchronized (thread) {
                        Boot.MAIN.wait();
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                    break;
                }
            }
            this.start(Lifecycle.Phase.SHUTDOWN);
            atomicBoolean.set(true);
            System.exit(0);
        }

        private void start(Lifecycle.Phase phase) {
            this.current.set(phase);
            Thread.currentThread().setName("aeonics #0 > Main :: " + this.current);
            long l = System.currentTimeMillis();
            ((Logger)Manager.of(Logger.class)).finer(Lifecycle.class, (Object)("Phase " + phase + " initiated"));
            try {
                Implementation.before((Lifecycle.Phase)phase).trigger((Object)phase);
                Implementation.on((Lifecycle.Phase)phase).trigger((Object)phase);
                Implementation.after((Lifecycle.Phase)phase).trigger((Object)phase);
                long l2 = System.currentTimeMillis();
                ((Logger)Manager.of(Logger.class)).fine(Lifecycle.class, (Object)("Phase " + phase + " completed in " + (l2 - l) + "ms"));
            }
            catch (Exception exception) {
                ((Logger)Manager.of(Logger.class)).severe(Lifecycle.class, (Object)("Phase " + phase + " failed unexpectedly"));
                ((Logger)Manager.of(Logger.class)).fine(Lifecycle.class, (Throwable)exception);
            }
        }

        public Lifecycle.Phase phase() {
            return this.current.get();
        }
    }
}

