/*
 * Decompiled with CFR 0.152.
 */
package aeonics.manager;

import aeonics.data.Data;
import aeonics.entity.Entity;
import aeonics.manager.Manager;
import aeonics.util.StringUtils;

public abstract class Monitor
extends Manager.Type {
    public static final String UNSPECIFIED = "unspecified";

    @Override
    public final Class<? extends Manager.Type> manager() {
        return Monitor.class;
    }

    public static Monitor get() {
        return Manager.of(Monitor.class);
    }

    public void count(Entity entity) {
        this.add(entity.category(), StringUtils.toLowerCase(entity.getClass()), entity.id(), "hit", 0L);
    }

    public void count(Entity entity, long l) {
        this.add(entity.category(), StringUtils.toLowerCase(entity.getClass()), entity.id(), "hit", l);
    }

    public void count(Entity entity, String string, long l) {
        this.add(entity.category(), StringUtils.toLowerCase(entity.getClass()), entity.id(), string, l);
    }

    public <T extends Entity> void count(T t, Class<? super T> clazz) {
        this.add(t.category(), StringUtils.toLowerCase(clazz), t.id(), "hit", 0L);
    }

    public <T extends Entity> void count(T t, Class<? super T> clazz, long l) {
        this.add(t.category(), StringUtils.toLowerCase(clazz), t.id(), "hit", l);
    }

    public <T extends Entity> void count(T t, Class<? super T> clazz, String string, long l) {
        this.add(t.category(), StringUtils.toLowerCase(clazz), t.id(), string, l);
    }

    public <T extends Entity> MonitorTimer ms(T t) {
        return this.ms(t, StringUtils.toLowerCase(t.getClass()), "ms");
    }

    public <T extends Entity> MonitorTimer ms(T t, String string) {
        return this.ms(t, StringUtils.toLowerCase(t.getClass()), string);
    }

    public <T extends Entity> MonitorTimer ms(T t, Class<? super T> clazz) {
        return this.ms(t, StringUtils.toLowerCase(clazz), "ms");
    }

    public <T extends Entity> MonitorTimer ms(T t, Class<? super T> clazz, String string) {
        return this.ms(t, StringUtils.toLowerCase(clazz), "ms");
    }

    public <T extends Entity> MonitorTimer ms(T t, String string, String string2) {
        long l = System.currentTimeMillis();
        return new MonitorTimer(() -> this.add(t.category(), string, t.id(), string2, System.currentTimeMillis() - l));
    }

    public <T extends Entity> MonitorTimer ns(T t) {
        return this.ns(t, StringUtils.toLowerCase(t.getClass()), "ns");
    }

    public <T extends Entity> MonitorTimer ns(T t, String string) {
        return this.ns(t, StringUtils.toLowerCase(t.getClass()), string);
    }

    public <T extends Entity> MonitorTimer ns(T t, Class<? super T> clazz) {
        return this.ns(t, StringUtils.toLowerCase(clazz), "ns");
    }

    public <T extends Entity> MonitorTimer ns(T t, Class<? super T> clazz, String string) {
        return this.ns(t, StringUtils.toLowerCase(clazz), "ns");
    }

    public <T extends Entity> MonitorTimer ns(T t, String string, String string2) {
        long l = System.nanoTime();
        return new MonitorTimer(() -> this.add(t.category(), string, t.id(), string2, System.nanoTime() - l));
    }

    public void countFor(Entity entity, Entity entity2) {
        this.add(entity.category(), StringUtils.toLowerCase(entity.getClass()), entity.id(), entity2.id(), 0L);
    }

    public void countFor(Entity entity, Entity entity2, long l) {
        this.add(entity.category(), StringUtils.toLowerCase(entity.getClass()), entity.id(), entity2.id(), l);
    }

    public <T extends Entity> void countFor(T t, Entity entity, Class<? super T> clazz) {
        this.add(t.category(), StringUtils.toLowerCase(clazz), t.id(), entity.id(), 0L);
    }

    public <T extends Entity> void countFor(T t, Entity entity, Class<? super T> clazz, long l) {
        this.add(t.category(), StringUtils.toLowerCase(clazz), t.id(), entity.id(), l);
    }

    public abstract void add(String var1, String var2, String var3, String var4, long var5);

    public Data report() {
        return this.report(null, null, null, null);
    }

    public Data report(Entity entity) {
        return this.report(entity.category(), StringUtils.toLowerCase(entity.getClass()), entity.id(), null);
    }

    public abstract Data report(String var1, String var2, String var3, String var4);

    public static class MonitorTimer
    implements AutoCloseable {
        Runnable onClose = null;

        public MonitorTimer(Runnable runnable) {
            this.onClose = runnable;
        }

        @Override
        public void close() {
            if (this.onClose != null) {
                this.onClose.run();
            }
            this.onClose = null;
        }
    }
}

