/*
 * Decompiled with CFR 0.152.
 */
package aeonics.manager;

import aeonics.manager.Manager;
import aeonics.template.Factory;
import aeonics.template.Template;
import aeonics.util.Json;
import java.util.function.Supplier;

public abstract class Logger
extends Manager.Type {
    public static final int SEVERE = 1000;
    public static final int WARNING = 900;
    public static final int INFO = 800;
    public static final int CONFIG = 700;
    public static final int FINE = 500;
    public static final int FINER = 400;
    public static final int FINEST = 300;
    public static final int ALL = -1;
    protected int level = 700;
    public static final Logger CONSOLE = Manager.set(Logger.class, (Logger)Factory.add(new ConsoleLogger()).create().name("Console Logger"));

    @Override
    public final Class<? extends Manager.Type> manager() {
        return Logger.class;
    }

    public static Logger get() {
        return Manager.of(Logger.class);
    }

    public int level() {
        return this.level;
    }

    public synchronized void level(int n) {
        if (n > this.level) {
            this.log(this.level, Logger.class, "Log level changed from {} to {}", this.level, n);
        }
        this.level = n;
    }

    public void log(int n, Class<?> clazz, Object object) {
        this.log(n, clazz == null ? null : clazz.getCanonicalName(), "{}", object);
    }

    public void log(int n, Class<?> clazz, Throwable throwable) {
        this.log(n, clazz == null ? null : clazz.getCanonicalName(), "{}", throwable);
    }

    public void log(int n, Class<?> clazz, String string, Object ... objectArray) {
        this.log(n, clazz == null ? null : clazz.getCanonicalName(), string, objectArray);
    }

    public void log(int n, String string, Object object) {
        this.log(n, string, "{}", object);
    }

    public void log(int n, String string, Throwable throwable) {
        this.log(n, string, "{}", throwable);
    }

    public void log(int n, String string, String string2, Object ... objectArray) {
        if (n < this.level() || string2 == null) {
            return;
        }
        this.handle(n, string == null || string.length() == 0 ? "global" : string, string2, objectArray);
    }

    public void log(int n, Class<?> clazz, String string, Supplier<Object[]> supplier) {
        if (n < this.level() || string == null) {
            return;
        }
        this.log(n, clazz == null ? null : clazz.getCanonicalName(), string, supplier.get());
    }

    public void log(int n, String string, String string2, Supplier<Object[]> supplier) {
        if (n < this.level() || string2 == null) {
            return;
        }
        this.log(n, string, string2, supplier.get());
    }

    public void severe(Class<?> clazz, Object object) {
        this.log(1000, clazz == null ? null : clazz.getCanonicalName(), "{}", object);
    }

    public void severe(Class<?> clazz, Throwable throwable) {
        this.log(1000, clazz == null ? null : clazz.getCanonicalName(), "{}", throwable);
    }

    public void severe(Class<?> clazz, String string, Object ... objectArray) {
        this.log(1000, clazz == null ? null : clazz.getCanonicalName(), string, objectArray);
    }

    public void severe(String string, Object object) {
        this.log(1000, string, "{}", object);
    }

    public void severe(String string, Throwable throwable) {
        this.log(1000, string, "{}", throwable);
    }

    public void severe(String string, String string2, Object ... objectArray) {
        this.log(1000, string, string2, objectArray);
    }

    public void severe(Class<?> clazz, String string, Supplier<Object[]> supplier) {
        this.log(1000, clazz, string, supplier);
    }

    public void severe(String string, String string2, Supplier<Object[]> supplier) {
        this.log(1000, string, string2, supplier);
    }

    public void warning(Class<?> clazz, Object object) {
        this.log(900, clazz == null ? null : clazz.getCanonicalName(), "{}", object);
    }

    public void warning(Class<?> clazz, Throwable throwable) {
        this.log(900, clazz == null ? null : clazz.getCanonicalName(), "{}", throwable);
    }

    public void warning(Class<?> clazz, String string, Object ... objectArray) {
        this.log(900, clazz == null ? null : clazz.getCanonicalName(), string, objectArray);
    }

    public void warning(String string, Object object) {
        this.log(900, string, "{}", object);
    }

    public void warning(String string, Throwable throwable) {
        this.log(900, string, "{}", throwable);
    }

    public void warning(String string, String string2, Object ... objectArray) {
        this.log(900, string, string2, objectArray);
    }

    public void warning(Class<?> clazz, String string, Supplier<Object[]> supplier) {
        this.log(900, clazz, string, supplier);
    }

    public void warning(String string, String string2, Supplier<Object[]> supplier) {
        this.log(900, string, string2, supplier);
    }

    public void info(Class<?> clazz, Object object) {
        this.log(800, clazz == null ? null : clazz.getCanonicalName(), "{}", object);
    }

    public void info(Class<?> clazz, Throwable throwable) {
        this.log(800, clazz == null ? null : clazz.getCanonicalName(), "{}", throwable);
    }

    public void info(Class<?> clazz, String string, Object ... objectArray) {
        this.log(800, clazz == null ? null : clazz.getCanonicalName(), string, objectArray);
    }

    public void info(String string, Object object) {
        this.log(800, string, "{}", object);
    }

    public void info(String string, Throwable throwable) {
        this.log(800, string, "{}", throwable);
    }

    public void info(String string, String string2, Object ... objectArray) {
        this.log(800, string, string2, objectArray);
    }

    public void info(Class<?> clazz, String string, Supplier<Object[]> supplier) {
        this.log(800, clazz, string, supplier);
    }

    public void info(String string, String string2, Supplier<Object[]> supplier) {
        this.log(800, string, string2, supplier);
    }

    public void config(Class<?> clazz, Object object) {
        this.log(700, clazz == null ? null : clazz.getCanonicalName(), "{}", object);
    }

    public void config(Class<?> clazz, Throwable throwable) {
        this.log(700, clazz == null ? null : clazz.getCanonicalName(), "{}", throwable);
    }

    public void config(Class<?> clazz, String string, Object ... objectArray) {
        this.log(700, clazz == null ? null : clazz.getCanonicalName(), string, objectArray);
    }

    public void config(String string, Object object) {
        this.log(700, string, "{}", object);
    }

    public void config(String string, Throwable throwable) {
        this.log(700, string, "{}", throwable);
    }

    public void config(String string, String string2, Object ... objectArray) {
        this.log(700, string, string2, objectArray);
    }

    public void config(Class<?> clazz, String string, Supplier<Object[]> supplier) {
        this.log(700, clazz, string, supplier);
    }

    public void config(String string, String string2, Supplier<Object[]> supplier) {
        this.log(700, string, string2, supplier);
    }

    public void fine(Class<?> clazz, Object object) {
        this.log(500, clazz == null ? null : clazz.getCanonicalName(), "{}", object);
    }

    public void fine(Class<?> clazz, Throwable throwable) {
        this.log(500, clazz == null ? null : clazz.getCanonicalName(), "{}", throwable);
    }

    public void fine(Class<?> clazz, String string, Object ... objectArray) {
        this.log(500, clazz == null ? null : clazz.getCanonicalName(), string, objectArray);
    }

    public void fine(String string, Object object) {
        this.log(500, string, "{}", object);
    }

    public void fine(String string, Throwable throwable) {
        this.log(500, string, "{}", throwable);
    }

    public void fine(String string, String string2, Object ... objectArray) {
        this.log(500, string, string2, objectArray);
    }

    public void fine(Class<?> clazz, String string, Supplier<Object[]> supplier) {
        this.log(500, clazz, string, supplier);
    }

    public void fine(String string, String string2, Supplier<Object[]> supplier) {
        this.log(500, string, string2, supplier);
    }

    public void finer(Class<?> clazz, Object object) {
        this.log(400, clazz == null ? null : clazz.getCanonicalName(), "{}", object);
    }

    public void finer(Class<?> clazz, Throwable throwable) {
        this.log(400, clazz == null ? null : clazz.getCanonicalName(), "{}", throwable);
    }

    public void finer(Class<?> clazz, String string, Object ... objectArray) {
        this.log(400, clazz == null ? null : clazz.getCanonicalName(), string, objectArray);
    }

    public void finer(String string, Object object) {
        this.log(400, string, "{}", object);
    }

    public void finer(String string, Throwable throwable) {
        this.log(400, string, "{}", throwable);
    }

    public void finer(String string, String string2, Object ... objectArray) {
        this.log(400, string, string2, objectArray);
    }

    public void finer(Class<?> clazz, String string, Supplier<Object[]> supplier) {
        this.log(400, clazz, string, supplier);
    }

    public void finer(String string, String string2, Supplier<Object[]> supplier) {
        this.log(400, string, string2, supplier);
    }

    public void finest(Class<?> clazz, Object object) {
        this.log(300, clazz == null ? null : clazz.getCanonicalName(), "{}", object);
    }

    public void finest(Class<?> clazz, Throwable throwable) {
        this.log(300, clazz == null ? null : clazz.getCanonicalName(), "{}", throwable);
    }

    public void finest(Class<?> clazz, String string, Object ... objectArray) {
        this.log(300, clazz == null ? null : clazz.getCanonicalName(), string, objectArray);
    }

    public void finest(String string, Object object) {
        this.log(300, string, "{}", object);
    }

    public void finest(String string, Throwable throwable) {
        this.log(300, string, "{}", throwable);
    }

    public void finest(String string, String string2, Object ... objectArray) {
        this.log(300, string, string2, objectArray);
    }

    public void finest(Class<?> clazz, String string, Supplier<Object[]> supplier) {
        this.log(300, clazz, string, supplier);
    }

    public void finest(String string, String string2, Supplier<Object[]> supplier) {
        this.log(300, string, string2, supplier);
    }

    protected abstract void handle(int var1, String var2, String var3, Object ... var4);

    protected String toJson(int n, String string, String string2, Object ... objectArray) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("{\"date\": ");
        stringBuilder.append(System.currentTimeMillis());
        stringBuilder.append(", \"level\": ");
        stringBuilder.append(n);
        stringBuilder.append(", \"type\": \"");
        stringBuilder.append(Json.escape(string));
        stringBuilder.append("\", \"message\": \"");
        if (objectArray != null && objectArray.length > 0) {
            stringBuilder.append(Json.escape(this.bindMessage(string2, objectArray)));
        } else {
            stringBuilder.append(Json.escape(string2));
        }
        stringBuilder.append("\"}");
        return stringBuilder.toString();
    }

    protected String bindMessage(String string, Object ... objectArray) {
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = 0;
        for (int i = 0; i < objectArray.length && (n = string.indexOf("{}", n2)) >= 0; ++i) {
            stringBuilder.append(string.substring(n2, n));
            n2 = n + 2;
            if (objectArray[i] == null) {
                stringBuilder.append("null");
                continue;
            }
            if (objectArray[i] instanceof Throwable) {
                stringBuilder.append(this.printStackTrace((Throwable)objectArray[i]));
                continue;
            }
            stringBuilder.append(objectArray[i].toString());
        }
        if (n2 < string.length()) {
            stringBuilder.append(string.substring(n2));
        }
        return stringBuilder.toString();
    }

    protected String printStackTrace(Throwable throwable) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Throwable throwable2 = throwable; throwable2 != null; throwable2 = throwable2.getCause()) {
            stringBuilder.append(throwable2.toString());
            stringBuilder.append('\n');
            for (StackTraceElement stackTraceElement : throwable2.getStackTrace()) {
                if (this.level() > -1 && (stackTraceElement.getModuleName() != null && stackTraceElement.getModuleName().startsWith("java.") || stackTraceElement.getClassName().startsWith("java.") || stackTraceElement.getClassName().startsWith("javax.") || stackTraceElement.getClassName().startsWith("jdk.") || stackTraceElement.getClassName().startsWith("sun.") || stackTraceElement.getClassName().startsWith("aeonics."))) continue;
                stringBuilder.append("\tat ");
                stringBuilder.append(stackTraceElement.toString());
                stringBuilder.append('\n');
            }
            if (throwable2.getCause() == null) continue;
            stringBuilder.append("Caused by:");
            stringBuilder.append('\n');
        }
        return stringBuilder.toString();
    }

    private static final class ConsoleLogger
    extends Manager<Logger> {
        private ConsoleLogger() {
        }

        @Override
        public Template<? extends Logger> template() {
            return ((Template)((Template)new Template(this.target(), this.type(), this.category()).creator(this.creator())).summary("Console logger")).description("Sends all logs in JSON format to the standard output console regardless of the log level.");
        }

        @Override
        protected Class<? extends Implementation> defaultTarget() {
            return Implementation.class;
        }

        @Override
        protected Supplier<? extends Implementation> defaultCreator() {
            return Implementation::new;
        }

        private static class Implementation
        extends Logger {
            public Implementation() {
                try {
                    String string = System.getProperty("AEONICS_MANAGER_LOGGER_LEVEL");
                    if (string == null || string.isBlank()) {
                        string = System.getenv("AEONICS_MANAGER_LOGGER_LEVEL");
                    }
                    if (string == null || string.isBlank()) {
                        string = "700";
                    }
                    this.level = Integer.parseInt(string);
                }
                catch (Exception exception) {
                    this.level = 700;
                }
            }

            @Override
            protected void handle(int n, String string, String string2, Object ... objectArray) {
                if (n < this.level() || string2 == null || string2.isBlank()) {
                    return;
                }
                String string3 = this.toJson(n, string, string2, objectArray);
                System.out.println(string3);
            }
        }
    }
}

