/*
 * Decompiled with CFR 0.152.
 */
package aeonics.manager;

import aeonics.manager.Logger;
import aeonics.manager.Manager;
import aeonics.manager.Monitor;
import aeonics.template.Factory;
import aeonics.template.Template;
import aeonics.util.Functions;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;

public abstract class Executor
extends Manager.Type {
    public static final Executor SYNCHRONOUS = Manager.set(Executor.class, (Executor)Factory.add(new SynchronousExecutor()).create().name("Synchronous Executor"));

    @Override
    public final Class<? extends Manager.Type> manager() {
        return Executor.class;
    }

    public static Executor get() {
        return Manager.of(Executor.class);
    }

    public Task<Void> priority(Functions.Runnable runnable) {
        return this.priority(() -> {
            runnable.run();
            return null;
        });
    }

    public abstract <T> Task<T> priorityResolved(T var1);

    public abstract <T> Task<T> priorityPending();

    public abstract Task<Void> priorityFailed(Throwable var1);

    public abstract Task<Void> priority(List<Task<?>> var1);

    public abstract <T> Task<T> priority(Functions.Supplier<T> var1);

    public abstract boolean isPriority(Thread var1);

    public boolean isPriority() {
        return this.isPriority(Thread.currentThread());
    }

    public Task<Void> normal(Functions.Runnable runnable) {
        return this.normal(() -> {
            runnable.run();
            return null;
        });
    }

    public abstract <T> Task<T> normalResolved(T var1);

    public abstract <T> Task<T> normalPending();

    public abstract Task<Void> normalFailed(Throwable var1);

    public abstract Task<Void> normal(List<Task<?>> var1);

    public abstract <T> Task<T> normal(Functions.Supplier<T> var1);

    public abstract boolean isNormal(Thread var1);

    public boolean isNormal() {
        return this.isNormal(Thread.currentThread());
    }

    public Task<Void> background(Functions.Runnable runnable) {
        return this.background(() -> {
            runnable.run();
            return null;
        });
    }

    public abstract <T> Task<T> backgroundResolved(T var1);

    public abstract <T> Task<T> backgroundPending();

    public abstract Task<Void> backgroundFailed(Throwable var1);

    public abstract Task<Void> background(List<Task<?>> var1);

    public abstract <T> Task<T> background(Functions.Supplier<T> var1);

    public abstract boolean isBackground(Thread var1);

    public boolean isBackground() {
        return this.isBackground(Thread.currentThread());
    }

    public Task<Void> io(Functions.Runnable runnable) {
        return this.io(() -> {
            runnable.run();
            return null;
        });
    }

    public abstract <T> Task<T> ioResolved(T var1);

    public abstract <T> Task<T> ioPending();

    public abstract Task<Void> ioFailed(Throwable var1);

    public abstract Task<Void> io(List<Task<?>> var1);

    public abstract <T> Task<T> io(Functions.Supplier<T> var1);

    public abstract boolean isIo(Thread var1);

    public boolean isIo() {
        return this.isIo(Thread.currentThread());
    }

    protected static <T> Task<T> completed(T t, java.util.concurrent.Executor executor) {
        return Task.completed(t, executor);
    }

    protected static Task<Void> failed(Throwable throwable, java.util.concurrent.Executor executor) {
        return Task.failed(throwable, executor);
    }

    protected static Task<Void> all(List<Task<?>> list, java.util.concurrent.Executor executor) {
        return Task.all(list, executor);
    }

    protected static <U> Task<U> sync(Functions.Supplier<U> supplier, java.util.concurrent.Executor executor) {
        return Task.sync(supplier, executor);
    }

    protected static <U> Task<U> async(Functions.Supplier<U> supplier, java.util.concurrent.Executor executor) {
        return Task.async(supplier, executor);
    }

    protected static <U> Task<U> pending(java.util.concurrent.Executor executor) {
        return new Task(null, executor);
    }

    private static final class SynchronousExecutor
    extends Manager<Executor> {
        private SynchronousExecutor() {
        }

        @Override
        public Template<? extends Executor> template() {
            return ((Template)((Template)new Template(this.target(), this.type(), this.category()).creator(this.creator())).summary("Synchronous executor")).description("Executes all tasks immediately and synchronously in the calling thread.");
        }

        @Override
        protected Class<? extends Implementation> defaultTarget() {
            return Implementation.class;
        }

        @Override
        protected Supplier<? extends Implementation> defaultCreator() {
            return () -> new Implementation();
        }

        private static class Implementation
        extends Executor {
            private Implementation() {
            }

            @Override
            public <T> Task<T> priority(Functions.Supplier<T> supplier) {
                return this.normal(supplier);
            }

            @Override
            public <T> Task<T> priorityResolved(T t) {
                return this.normalResolved(t);
            }

            @Override
            public <T> Task<T> priorityPending() {
                return Implementation.pending(null);
            }

            @Override
            public Task<Void> priorityFailed(Throwable throwable) {
                return this.normalFailed(throwable);
            }

            @Override
            public Task<Void> priority(List<Task<?>> list) {
                return this.normal(list);
            }

            @Override
            public boolean isPriority(Thread thread) {
                return false;
            }

            @Override
            public <T> Task<T> normal(Functions.Supplier<T> supplier) {
                try {
                    T t = supplier.get();
                    return Task.completed(t, null);
                }
                catch (Throwable throwable) {
                    return Task.failed(throwable, null);
                }
            }

            @Override
            public <T> Task<T> normalResolved(T t) {
                return Implementation.completed(t, null);
            }

            @Override
            public <T> Task<T> normalPending() {
                return Implementation.pending(null);
            }

            @Override
            public Task<Void> normalFailed(Throwable throwable) {
                return Implementation.failed(throwable, null);
            }

            @Override
            public Task<Void> normal(List<Task<?>> list) {
                return Implementation.all(list, null);
            }

            @Override
            public boolean isNormal(Thread thread) {
                return true;
            }

            @Override
            public <T> Task<T> background(Functions.Supplier<T> supplier) {
                return this.normal(supplier);
            }

            @Override
            public <T> Task<T> backgroundResolved(T t) {
                return this.normalResolved(t);
            }

            @Override
            public <T> Task<T> backgroundPending() {
                return Implementation.pending(null);
            }

            @Override
            public Task<Void> backgroundFailed(Throwable throwable) {
                return this.normalFailed(throwable);
            }

            @Override
            public Task<Void> background(List<Task<?>> list) {
                return this.normal(list);
            }

            @Override
            public boolean isBackground(Thread thread) {
                return false;
            }

            @Override
            public <T> Task<T> io(Functions.Supplier<T> supplier) {
                return this.normal(supplier);
            }

            @Override
            public <T> Task<T> ioResolved(T t) {
                return this.normalResolved(t);
            }

            @Override
            public <T> Task<T> ioPending() {
                return Implementation.pending(null);
            }

            @Override
            public Task<Void> ioFailed(Throwable throwable) {
                return this.normalFailed(throwable);
            }

            @Override
            public Task<Void> io(List<Task<?>> list) {
                return this.normal(list);
            }

            @Override
            public boolean isIo(Thread thread) {
                return false;
            }
        }
    }

    public static final class Task<T> {
        private final CompletableFuture<T> future;
        private final java.util.concurrent.Executor executor;

        protected static <T> Task<T> completed(T t, java.util.concurrent.Executor executor) {
            return new Task<T>(CompletableFuture.completedFuture(t), executor);
        }

        public static Task<Void> unknown() {
            return new Task<Object>(CompletableFuture.completedFuture(null));
        }

        protected static Task<Void> failed(Throwable throwable, java.util.concurrent.Executor executor) {
            return new Task<Void>(CompletableFuture.failedFuture(throwable), executor);
        }

        private static <T> Supplier<T> wrap(Functions.Supplier<T> supplier) {
            return () -> {
                long l = System.nanoTime();
                try {
                    Object r = supplier.get();
                    return r;
                }
                catch (Exception exception) {
                    Manager.of(Logger.class).warning(Executor.class, (Throwable)exception);
                    throw new RuntimeException(exception);
                }
                finally {
                    long l2 = System.nanoTime();
                    Manager.of(Monitor.class).count(Manager.of(Monitor.class), "ns", l2 - l);
                }
            };
        }

        private static <T, U> Function<T, U> wrap(Functions.Function<T, U> function) {
            return object -> {
                long l = System.nanoTime();
                try {
                    Object r = function.apply(object);
                    return r;
                }
                catch (Exception exception) {
                    Manager.of(Logger.class).warning(Executor.class, (Throwable)exception);
                    throw new RuntimeException(exception);
                }
                finally {
                    long l2 = System.nanoTime();
                    Manager.of(Monitor.class).count(Manager.of(Monitor.class), "ns", l2 - l);
                }
            };
        }

        private static <T, U> BiFunction<T, Throwable, U> wrap(Functions.BiFunction<T, Throwable, U> biFunction) {
            return (object, throwable) -> {
                long l = System.nanoTime();
                try {
                    Object r = biFunction.apply((Object)object, (Throwable)throwable);
                    return r;
                }
                catch (Exception exception) {
                    Manager.of(Logger.class).warning(Executor.class, (Throwable)exception);
                    throw new RuntimeException(exception);
                }
                finally {
                    long l2 = System.nanoTime();
                    Manager.of(Monitor.class).count(Manager.of(Monitor.class), "ns", l2 - l);
                }
            };
        }

        protected static <U> Task<U> sync(Functions.Supplier<U> supplier, java.util.concurrent.Executor executor) {
            return new Task<U>(CompletableFuture.supplyAsync(Task.wrap(supplier), executor));
        }

        protected static <U> Task<U> async(Functions.Supplier<U> supplier, java.util.concurrent.Executor executor) {
            return new Task<U>(CompletableFuture.supplyAsync(Task.wrap(supplier), executor), executor);
        }

        private Task(CompletableFuture<T> completableFuture) {
            this(completableFuture, null);
        }

        private Task(CompletableFuture<T> completableFuture, java.util.concurrent.Executor executor) {
            this.executor = executor;
            this.future = Objects.requireNonNullElseGet(completableFuture, () -> new CompletableFuture());
        }

        public Task<Void> then(Functions.Runnable runnable) {
            return this.then((? super T object) -> {
                runnable.run();
                return null;
            });
        }

        public Task<Void> then(Functions.Consumer<? super T> consumer) {
            return this.then((? super T object) -> {
                consumer.accept((Object)object);
                return null;
            });
        }

        public <U> Task<U> then(Functions.Supplier<? extends U> supplier) {
            return this.then((? super T object) -> supplier.get());
        }

        public <U> Task<U> then(Functions.Function<? super T, ? extends U> function) {
            if (this.executor == null) {
                return new Task<T>(this.future.thenApply(Task.wrap(function)));
            }
            return new Task<T>(this.future.thenApplyAsync(Task.wrap(function), this.executor), this.executor);
        }

        public Task<T> or(Functions.Runnable runnable) {
            return this.or((Throwable throwable) -> {
                runnable.run();
                return null;
            });
        }

        public Task<T> or(Functions.Consumer<Throwable> consumer) {
            return this.or((Throwable throwable) -> {
                consumer.accept((Throwable)throwable);
                return null;
            });
        }

        public Task<T> or(Functions.Supplier<? extends T> supplier) {
            return this.or((Throwable throwable) -> supplier.get());
        }

        public Task<T> or(Functions.Function<Throwable, ? extends T> function) {
            if (this.executor == null) {
                return new Task<T>(this.future.exceptionally(Task.wrap(function)));
            }
            return new Task<T>(this.future.handleAsync(Task.wrap((T object, Throwable throwable) -> {
                if (throwable != null) {
                    return function.apply((Throwable)throwable);
                }
                return object;
            }), this.executor), this.executor);
        }

        public Task<Void> anyway(Functions.Runnable runnable) {
            return this.anyway((T object, Throwable throwable) -> {
                runnable.run();
                return null;
            });
        }

        public Task<Void> anyway(Functions.BiConsumer<T, Throwable> biConsumer) {
            return this.anyway((T object, Throwable throwable) -> {
                biConsumer.accept((Object)object, (Throwable)throwable);
                return null;
            });
        }

        public <U> Task<U> anyway(Functions.Supplier<? extends U> supplier) {
            return this.anyway((T object, Throwable throwable) -> supplier.get());
        }

        public <U> Task<U> anyway(Functions.BiFunction<T, Throwable, ? extends U> biFunction) {
            if (this.executor == null) {
                return new Task<T>(this.future.handle(Task.wrap(biFunction)));
            }
            return new Task<T>(this.future.handleAsync(Task.wrap(biFunction), this.executor), this.executor);
        }

        public <U> Task<U> link(Task<U> task) {
            return new Task<T>(this.future.thenCompose(object -> task.future));
        }

        public <U> Task<U> link(Functions.Function<T, Task<U>> function) {
            return new Task<T>(this.future.thenCompose(object -> ((Task)Task.wrap(function).apply(object)).future));
        }

        public T await() {
            return this.future.join();
        }

        protected static Task<Void> all(List<Task<?>> list, java.util.concurrent.Executor executor) {
            if (list == null || list.size() == 0) {
                return Task.completed(null, executor);
            }
            CompletableFuture[] completableFutureArray = new CompletableFuture[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                completableFutureArray[i] = list.get((int)i).future;
            }
            return new Task<Void>(CompletableFuture.allOf(completableFutureArray), executor);
        }

        public void cancel() {
            this.future.cancel(true);
        }

        public void complete(T t) {
            this.future.complete(t);
        }

        public void fail(Exception exception) {
            this.future.completeExceptionally(exception);
        }
    }
}

