/*
 * Decompiled with CFR 0.152.
 */
package aeonics.entity.security;

import aeonics.data.Data;
import aeonics.entity.Entity;
import aeonics.entity.security.Role;
import aeonics.template.Item;
import aeonics.template.Parameter;
import aeonics.template.Relationship;
import aeonics.template.Template;
import aeonics.util.Json;
import aeonics.util.Snapshotable;
import aeonics.util.StringUtils;
import java.util.function.Supplier;

public class Group
extends Item<Type> {
    public static final Type ADMINISTRATORS = (Type)((Entity)((Entity)((Entity)new Group().template().create(Data.map().put("id", "10000000-1800000000000000")).name("Administrators")).internal(true)).snapshotMode(Snapshotable.SnapshotMode.UPDATE)).addRelation("roles", Role.SUPERADMIN).cast();
    public static final Type USERS = (Type)((Entity)((Entity)new Group().template().create(Data.map().put("id", "10000000-1900000000000000")).name("Users")).internal(true)).snapshotMode(Snapshotable.SnapshotMode.UPDATE);

    @Override
    protected Class<? extends Type> defaultTarget() {
        return Type.class;
    }

    @Override
    protected Supplier<? extends Type> defaultCreator() {
        return Type::new;
    }

    @Override
    protected Class<? extends Group> category() {
        return Group.class;
    }

    @Override
    public Template<? extends Type> template() {
        return ((Template)((Template)((Template)super.template().summary("User Group")).description("A group represents a set of users that share common attributes and/or roles. It is useful if you have predefined security policies and you do not want to defined them on a per-user level.")).add((Parameter)((Parameter)((Parameter)((Parameter)((Parameter)new Parameter("attributes").summary("Attributes")).description("Additional group attributes that all users of this group shall inherit.")).defaultValue(Data.map())).format("json")).rule(Parameter.Rule.JSON_MAP).optional(true).validator(data -> data != null && (data.isMap() || Json.decode(data.asString()).isMap())))).add((Relationship)((Relationship)((Relationship)new Relationship("roles").category(Role.class)).summary("Roles")).description("List of roles that apply to all users in this group."));
    }

    public static class Type
    extends Entity {
        @Override
        public final String category() {
            return StringUtils.toLowerCase(Group.class);
        }

        public Data attributes() {
            return this.valueOf("attributes");
        }
    }
}

