/*
 * Decompiled with CFR 0.152.
 */
package aeonics.entity;

import aeonics.data.Data;
import aeonics.entity.Database;
import aeonics.entity.Entity;
import aeonics.manager.Logger;
import aeonics.manager.Manager;
import aeonics.template.Item;
import aeonics.template.Parameter;
import aeonics.template.Relationship;
import aeonics.template.Template;
import aeonics.util.Functions;
import aeonics.util.Json;
import aeonics.util.StringUtils;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.sql.JDBCType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.Map;
import java.util.StringJoiner;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public abstract class Storage
extends Item<Type> {
    public static String normalize(String string) {
        if (string == null || string.isBlank()) {
            return "";
        }
        String[] stringArray = StringUtils.split(string.replace('\\', '/'), "/");
        LinkedList<String> linkedList = new LinkedList<String>();
        for (String string2 : stringArray) {
            if (string2.equals(".")) continue;
            if (string2.equals("..")) {
                if (linkedList.size() <= 0) continue;
                linkedList.removeLast();
                continue;
            }
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < string2.length(); ++i) {
                char c = string2.charAt(i);
                if (c < ' ') continue;
                stringBuilder.append(c);
            }
            linkedList.add(stringBuilder.toString());
        }
        StringJoiner stringJoiner = new StringJoiner("/");
        for (String string3 : linkedList) {
            stringJoiner.add(string3);
        }
        return stringJoiner.toString();
    }

    public static String resolve(String string, String string2) {
        return string + "/" + Storage.normalize(string2);
    }

    public static String relativize(String string, String string2) {
        String string3 = Storage.normalize(string);
        String string4 = Storage.normalize(string2);
        if (string4.startsWith(string3)) {
            return Storage.normalize(string4.substring(string3.length()));
        }
        return string4;
    }

    @Override
    protected Class<? extends Storage> category() {
        return Storage.class;
    }

    public static class Database
    extends Storage {
        @Override
        protected Class<? extends Type> defaultTarget() {
            return Type.class;
        }

        @Override
        protected Supplier<? extends Type> defaultCreator() {
            return Type::new;
        }

        @Override
        public Template<? extends Type> template() {
            return ((Template)((Template)((Template)super.template().summary("Database storage")).description("This storage uses a database connection to store data. Therefore, the path structure is limited and must always start with the table name and then the primary key of the record of interest. This also implies that this storage is only compatible with tables that define one simple primary key (no composite primary key is supported). In order to improve performance, this storage keeps a cache of the database schema. This cache is populated at first use and refreshed whenever the underlying database entity is updated.")).add((Relationship)((Relationship)((Relationship)((Relationship)((Relationship)new Relationship("database").category(aeonics.entity.Database.class)).summary("Database")).description("The target underlying database")).min(1)).max(1))).add(((Parameter)((Parameter)((Parameter)((Parameter)new Parameter("maxRecords").summary("Maximum record count")).description("When listing the content of the storage, a database may have a large number of rows. This parameter limits the number of returned elements. The elements are always sorted in ascending order. Setting this parameter to 0 or a negative value means unlimited.")).format("number")).rule(Parameter.Rule.INTEGER).defaultValue(-1)).optional(true));
        }

        public static class Type
        extends aeonics.entity.Storage$Type {
            private Functions.BiConsumer<Data, Entity> updateHandler;
            private Functions.BiConsumer<Void, Entity> removeHandler;
            private AtomicReference<Data> schema = new AtomicReference();
            private AtomicReference<Database.Type> db = new AtomicReference();

            public Type() {
                this.updateHandler = (data, entity) -> this.schema.set(null);
                this.removeHandler = (void_, entity) -> {
                    this.schema.set(null);
                    entity.onUpdate().remove(this.updateHandler);
                    entity.onRemove().remove(this.removeHandler);
                    this.db.set(null);
                };
            }

            private Path path(String string) {
                return Path.of(Storage.normalize(string), new String[0]);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private Data schema() {
                Data data = this.schema.get();
                if (data != null) {
                    return data;
                }
                AtomicReference<Data> atomicReference = this.schema;
                synchronized (atomicReference) {
                    if (this.schema.get() == null) {
                        try {
                            this.schema.set(this.db().schema());
                        }
                        catch (Exception exception) {
                            throw new RuntimeException("Database schema unavailable", exception);
                        }
                    }
                }
                return this.schema.get();
            }

            private Database.Type db() {
                Database.Type type;
                Database.Type type2 = (Database.Type)this.firstRelation("database");
                if (type2 != (type = this.db.get())) {
                    if (type != null) {
                        type.onRemove().remove(this.removeHandler);
                        type.onUpdate().remove(this.updateHandler);
                    }
                    if (type2 != null) {
                        type2.onRemove().then(this.removeHandler);
                        type2.onUpdate().then(this.updateHandler);
                    }
                    this.schema.set(null);
                    this.db.set(type2);
                }
                if (type2 == null) {
                    throw new IllegalStateException("Underlying database is not ready");
                }
                return type2;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public void put(String object, Data data) {
                Path path;
                if (object == null || ((String)object).isBlank()) {
                    throw new IllegalArgumentException("Invalid path " + (String)object);
                }
                if (((String)object).endsWith(".json")) {
                    object = ((String)object).substring(0, ((String)object).length() - 5);
                }
                if ((path = this.path((String)object)).getNameCount() == 2 || path.getNameCount() == 1 && ((String)object).endsWith("/")) {
                    try {
                        String string;
                        String string2 = path.getName(0).toString();
                        if (path.getNameCount() == 1) {
                            string = path.getName(0).toString();
                            boolean bl = false;
                            for (Object object2 : this.schema()) {
                                if (!string.equalsIgnoreCase(object2.asString("name"))) continue;
                                for (Object object3 : object2.get("columns")) {
                                    if (!object3.asBool("primary")) continue;
                                    for (Map.Entry object42 : data.entrySet()) {
                                        if (!((String)object42.getKey()).equalsIgnoreCase(object3.asString("name"))) continue;
                                        object = (String)object + ((Data)object42.getValue()).asString();
                                        path = this.path((String)object);
                                        bl = true;
                                    }
                                }
                            }
                            if (!bl) {
                                throw new RuntimeException("Could not infer record primary key");
                            }
                        }
                        string = path.getName(1).toString();
                        for (Object object5 : this.schema()) {
                            Object object6;
                            Object object3;
                            Object object2;
                            if (!string2.equalsIgnoreCase(object5.asString("name"))) continue;
                            if (this.containsEntry((String)object)) {
                                object2 = "UPDATE " + object5.asString("name") + " SET ";
                                object6 = new ArrayList<String>();
                                object3 = " WHERE ";
                                for (Data data2 : object5.get("columns")) {
                                    if (data2.asBool("primary")) {
                                        object3 = object3 + data2.asString("name") + " = ?";
                                    }
                                    for (Map.Entry<String, Data> entry : data.entrySet()) {
                                        if (!entry.getKey().equalsIgnoreCase(data2.asString("name"))) continue;
                                        object2 = (String)object2 + data2.asString("name") + " = ?,";
                                        object6.add(entry.getValue().asString());
                                    }
                                }
                                if (object6.size() == 0) {
                                    return;
                                }
                                object2 = ((String)object2).substring(0, ((String)object2).length() - 1);
                                object6.add(string);
                                this.db().query((String)object2 + (String)object3, (Collection<Object>)object6);
                                return;
                            }
                            object2 = "INSERT INTO " + object5.asString("name") + " (";
                            object6 = ") VALUES (";
                            object3 = new ArrayList();
                            boolean bl = false;
                            Object var12_25 = null;
                            for (Data data3 : object5.get("columns")) {
                                if (data3.asBool("primary")) {
                                    String string3 = data3.asString("name");
                                }
                                for (Map.Entry<String, Data> entry : data.entrySet()) {
                                    if (!entry.getKey().equalsIgnoreCase(data3.asString("name"))) continue;
                                    if (data3.asBool("primary")) {
                                        bl = true;
                                    }
                                    object2 = (String)object2 + data3.asString("name") + ",";
                                    object6 = (String)object6 + "?,";
                                    object3.add(entry.getValue().asString());
                                }
                            }
                            if (object3.size() == 0 && bl) {
                                return;
                            }
                            if (!bl) {
                                void var12_26;
                                object2 = (String)object2 + (String)var12_26 + ",";
                                object6 = object6 + "?,";
                                object3.add(string);
                            }
                            object2 = ((String)object2).substring(0, ((String)object2).length() - 1);
                            object6 = ((String)object6).substring(0, ((String)object6).length() - 1);
                            this.db().query((String)object2 + (String)object6 + ")", (Collection<Object>)object3);
                            return;
                        }
                    }
                    catch (Exception exception) {
                        throw new RuntimeException(exception);
                    }
                } else if (path.getNameCount() == 1) {
                    String string = path.getName(0).toString();
                    if (!StringUtils.isComposedOf(string, "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890_")) {
                        throw new IllegalArgumentException("Illegal table name " + string);
                    }
                    if (!data.isList("columns")) {
                        throw new IllegalArgumentException("Missing or invalid 'columns' definition");
                    }
                    String string3 = "CREATE TABLE " + string + " (";
                    Object object7 = "PRIMARY KEY (";
                    for (Data data3 : data.get("columns")) {
                        if (!data3.containsKey("name")) {
                            throw new IllegalArgumentException("Missing column name");
                        }
                        if (!StringUtils.isComposedOf(data3.asString("name"), "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890_")) {
                            throw new IllegalArgumentException("Illegal column name " + data3.asString("name"));
                        }
                        string3 = string3 + data3.asString("name") + " ";
                        JDBCType jDBCType = null;
                        jDBCType = data3.containsKey("type") ? JDBCType.valueOf(data3.asString("type")) : JDBCType.NVARCHAR;
                        string3 = string3 + jDBCType.getName();
                        if (data3.containsKey("size")) {
                            string3 = string3 + "(" + data3.asInt("size") + ")";
                        }
                        if (data3.containsKey("null") && !data3.asBool("null")) {
                            string3 = string3 + " NOT NULL";
                        }
                        if (data3.containsKey("primary") && data3.asBool("primary")) {
                            object7 = (String)object7 + data3.asString("name") + "))";
                        }
                        string3 = string3 + ", ";
                    }
                    try {
                        this.db().query(string3 + (String)object7, new Object[0]);
                    }
                    catch (Exception exception) {
                        throw new RuntimeException(exception);
                    }
                } else {
                    throw new IllegalArgumentException("Invalid path " + (String)object);
                }
            }

            @Override
            public void put(String string, String string2) {
                this.put(string, Json.decode(string2));
            }

            @Override
            public void put(String string, byte[] byArray) {
                this.put(string, Json.decode(new String(byArray, StandardCharsets.UTF_8)));
            }

            @Override
            public Data getData(String string) {
                Path path;
                if (string == null || string.isBlank()) {
                    return null;
                }
                if (string.endsWith(".json")) {
                    string = string.substring(0, string.length() - 5);
                }
                if ((path = this.path(string)).getNameCount() > 2) {
                    return null;
                }
                if (path.getNameCount() == 0 || path.equals(Path.of("", new String[0]))) {
                    return this.schema().clone();
                }
                if (path.getNameCount() == 1) {
                    String string2 = path.getName(0).toString();
                    for (Data data : this.schema()) {
                        if (!string2.equalsIgnoreCase(data.asString("name"))) continue;
                        return data.clone();
                    }
                    return null;
                }
                try {
                    String string3 = path.getName(0).toString();
                    String string4 = path.getName(1).toString();
                    for (Data data : this.schema()) {
                        if (!string3.equalsIgnoreCase(data.asString("name"))) continue;
                        for (Data data2 : data.get("columns")) {
                            if (!data2.asBool("primary")) continue;
                            Data data3 = this.db().query("SELECT * FROM " + data.asString("name") + " WHERE " + data2.asString("name") + " = ?", string4);
                            if (data3.isEmpty()) {
                                return null;
                            }
                            return data3.get(0);
                        }
                    }
                    return null;
                }
                catch (Exception exception) {
                    Manager.of(Logger.class).finer(Database.class, (Throwable)exception);
                    return null;
                }
            }

            @Override
            public String getString(String string) {
                Data data = this.getData(string);
                if (data == null) {
                    return null;
                }
                return data.toString();
            }

            @Override
            public byte[] get(String string) {
                Data data = this.getData(string);
                if (data == null) {
                    return null;
                }
                return data.toString().getBytes(StandardCharsets.UTF_8);
            }

            @Override
            public boolean containsEntry(String string) {
                Path path;
                if (string == null || string.isBlank()) {
                    return false;
                }
                if (string.endsWith(".json")) {
                    string = string.substring(0, string.length() - 5);
                }
                if ((path = this.path(string)).getNameCount() != 2) {
                    return false;
                }
                try {
                    String string2 = path.getName(0).toString();
                    String string3 = path.getName(1).toString();
                    for (Data data : this.schema()) {
                        if (!string2.equalsIgnoreCase(data.asString("name"))) continue;
                        for (Data data2 : data.get("columns")) {
                            if (!data2.asBool("primary")) continue;
                            Data data3 = this.db().query("SELECT " + data2.asString("name") + " FROM " + data.asString("name") + " WHERE " + data2.asString("name") + " = ?", string3);
                            return data3.size() == 1;
                        }
                    }
                    return false;
                }
                catch (Exception exception) {
                    Manager.of(Logger.class).finer(Database.class, (Throwable)exception);
                    return false;
                }
            }

            @Override
            public boolean containsPath(String string) {
                if (string == null) {
                    return false;
                }
                if (string.isBlank()) {
                    return true;
                }
                Path path = this.path(string);
                if (path.getNameCount() == 0 || path.equals(Path.of("", new String[0]))) {
                    return true;
                }
                if (path.getNameCount() != 1) {
                    return false;
                }
                try {
                    String string2 = path.getName(0).toString();
                    for (Data data : this.schema()) {
                        if (!string2.equalsIgnoreCase(data.asString("name"))) continue;
                        return true;
                    }
                    return false;
                }
                catch (Exception exception) {
                    Manager.of(Logger.class).finer(Database.class, (Throwable)exception);
                    return false;
                }
            }

            @Override
            public void remove(String string) {
                if (string == null) {
                    return;
                }
                if (string.endsWith(".json")) {
                    string = string.substring(0, string.length() - 5);
                }
                if (string.isBlank()) {
                    this.clear();
                    return;
                }
                Path path = this.path(string);
                if (path.getNameCount() == 0 || path.equals(Path.of("", new String[0]))) {
                    this.clear();
                    return;
                }
                if (path.getNameCount() > 2) {
                    return;
                }
                try {
                    String string2 = path.getName(0).toString();
                    String string3 = path.getNameCount() == 2 ? path.getName(1).toString() : null;
                    for (Data data : this.schema()) {
                        if (!string2.equalsIgnoreCase(data.asString("name"))) continue;
                        if (string3 == null) {
                            this.db().query("TRUNCATE TABLE " + data.asString("name"), new Object[0]);
                            return;
                        }
                        for (Data data2 : data.get("columns")) {
                            if (!data2.asBool("primary")) continue;
                            this.db().query("DELETE FROM " + data.asString("name") + " WHERE " + data2.asString("name") + " = ?", string3);
                            return;
                        }
                    }
                }
                catch (Exception exception) {
                    Manager.of(Logger.class).finer(Database.class, (Throwable)exception);
                }
            }

            @Override
            public Collection<String> list(String string) {
                Path path;
                if (string == null || string.isBlank()) {
                    return Collections.emptyList();
                }
                if (string.endsWith(".json")) {
                    string = string.substring(0, string.length() - 5);
                }
                if ((path = this.path(string)).getNameCount() >= 2) {
                    return Collections.emptyList();
                }
                if (path.getNameCount() == 0 || path.equals(Path.of("", new String[0]))) {
                    int n = this.valueOf("maxRecords").asInt();
                    ArrayList<String> arrayList = new ArrayList<String>();
                    for (Data data : this.schema()) {
                        String string3 = data.asString("name") + "/";
                        arrayList.addAll(this.tree(string3).stream().map(string2 -> string3.concat((String)string2)).collect(Collectors.toList()));
                        if (arrayList.size() < n) continue;
                        return arrayList;
                    }
                    return arrayList;
                }
                if (path.getNameCount() == 1) {
                    String string4 = path.getName(0).toString() + "/";
                    return this.tree(string).stream().map(string2 -> string3.concat((String)string2)).collect(Collectors.toList());
                }
                if (path.getNameCount() == 2 && this.containsEntry(string)) {
                    return Arrays.asList(string);
                }
                return Collections.emptyList();
            }

            @Override
            public Collection<String> tree(String string) {
                Path path;
                if (string == null || string.isBlank()) {
                    return Collections.emptyList();
                }
                if (string.endsWith(".json")) {
                    string = string.substring(0, string.length() - 5);
                }
                if ((path = this.path(string)).getNameCount() >= 2) {
                    return Collections.emptyList();
                }
                ArrayList<String> arrayList = new ArrayList<String>();
                if (path.getNameCount() == 0 || path.equals(Path.of("", new String[0]))) {
                    for (Data data : this.schema()) {
                        arrayList.add(data.asString("name") + "/");
                    }
                    return arrayList;
                }
                if (path.getNameCount() == 1) {
                    String string2 = path.getName(0).toString();
                    for (Data data : this.schema()) {
                        if (!string2.equalsIgnoreCase(data.asString("name"))) continue;
                        String string3 = null;
                        for (Data data2 : data.get("columns")) {
                            if (!data2.asBool("primary")) continue;
                            string3 = data2.asString("name");
                        }
                        if (string3 == null) {
                            return Collections.emptyList();
                        }
                        Object object = "SELECT " + string3 + " FROM " + data.asString("name") + " ORDER BY " + string3 + " ASC";
                        int n = this.valueOf("maxRecords").asInt();
                        if (n > 0) {
                            object = (String)object + " OFFSET 0 ROWS FETCH FIRST " + n + " ROWS ONLY";
                        }
                        try {
                            Data data3 = this.db().query((String)object, new Object[0]);
                            for (Data data4 : data3) {
                                arrayList.add(data4.asString(string3));
                            }
                            return arrayList;
                        }
                        catch (Exception exception) {
                            throw new RuntimeException(exception);
                        }
                    }
                }
                return Collections.emptyList();
            }

            @Override
            public void clear() {
                try {
                    for (Data data : this.schema()) {
                        this.db().query("DROP TABLE " + data.asString("name"), new Object[0]);
                    }
                }
                catch (Exception exception) {
                    Manager.of(Logger.class).finer(Database.class, (Throwable)exception);
                }
            }
        }
    }

    public static class Memory
    extends Storage {
        @Override
        protected Class<? extends Type> defaultTarget() {
            return Type.class;
        }

        @Override
        protected Supplier<? extends Type> defaultCreator() {
            return Type::new;
        }

        @Override
        public Template<? extends Type> template() {
            return ((Template)super.template().summary("Memory storage")).description("This storage is non-persistent as it stores content directly in the heap memory of the application. However, it is the fastest to read and write data.");
        }

        public static class Type
        extends aeonics.entity.Storage$Type {
            private ConcurrentHashMap<String, byte[]> store = new ConcurrentHashMap();

            @Override
            public void put(String string, byte[] byArray) {
                this.store.put(Storage.normalize(string), byArray);
            }

            @Override
            public byte[] get(String string) {
                return this.store.get(Storage.normalize(string));
            }

            @Override
            public boolean containsEntry(String string) {
                return this.store.containsKey(Storage.normalize(string));
            }

            @Override
            public boolean containsPath(String object) {
                object = Storage.normalize((String)object) + "/";
                for (String string : this.store.keySet()) {
                    if (!string.startsWith((String)object)) continue;
                    return true;
                }
                return false;
            }

            @Override
            public Collection<String> list(String string) {
                string = Storage.normalize(string);
                LinkedList<String> linkedList = new LinkedList<String>();
                for (String string2 : this.store.keySet()) {
                    if (!string2.startsWith(string)) continue;
                    linkedList.add(string2);
                }
                return linkedList;
            }

            @Override
            public Collection<String> tree(String object) {
                object = Storage.normalize((String)object);
                LinkedList<String> linkedList = new LinkedList<String>();
                if (this.store.containsKey(object)) {
                    return linkedList;
                }
                if (((String)object).length() > 0) {
                    object = (String)object + "/";
                }
                for (String string : this.store.keySet()) {
                    if (string.length() <= ((String)object).length() || !string.startsWith((String)object)) continue;
                    int n = (string = string.substring(((String)object).length())).indexOf(47);
                    if (n > -1) {
                        string = string.substring(0, n + 1);
                    }
                    if (string.length() <= 0 || linkedList.contains(string)) continue;
                    linkedList.add(string);
                }
                return linkedList;
            }

            @Override
            public void remove(String string) {
                string = Storage.normalize(string);
                for (String string2 : this.store.keySet()) {
                    if (!string2.startsWith(string)) continue;
                    this.store.remove(string2);
                }
            }

            @Override
            public void clear() {
                this.store.clear();
            }
        }
    }

    public static class File
    extends Storage {
        @Override
        protected Class<? extends Type> defaultTarget() {
            return Type.class;
        }

        @Override
        protected Supplier<? extends Type> defaultCreator() {
            return Type::new;
        }

        @Override
        public Template<? extends Type> template() {
            return ((Template)((Template)super.template().summary("Local file storage")).description("This storage is a direct access to the hard drive and stores the content in files as provided by the underlying operating system.")).add((Parameter)((Parameter)((Parameter)((Parameter)new Parameter("root").summary("Root directory")).description("The root directory of this storage. All content will be stored as file or directory under this root path.")).format("text")).optional(true).defaultValue(""));
        }

        public static class Type
        extends aeonics.entity.Storage$Type {
            private Path path(String string) {
                return Path.of(Storage.resolve(this.valueOf("root").asString(), string), new String[0]);
            }

            @Override
            public void put(String string, byte[] byArray) {
                Path path = this.path(string);
                try {
                    if (path.getParent() != null) {
                        Files.createDirectories(path.getParent(), new FileAttribute[0]);
                    }
                    Files.write(path, byArray, new OpenOption[0]);
                }
                catch (Exception exception) {
                    throw new RuntimeException(exception);
                }
            }

            @Override
            public byte[] get(String string) {
                Path path = this.path(string);
                try {
                    if (!Files.isRegularFile(path, new LinkOption[0])) {
                        return null;
                    }
                    return Files.readAllBytes(path);
                }
                catch (Exception exception) {
                    throw new RuntimeException(exception);
                }
            }

            @Override
            public boolean containsEntry(String string) {
                Path path = this.path(string);
                return Files.isRegularFile(path, new LinkOption[0]);
            }

            @Override
            public boolean containsPath(String string) {
                Path path = this.path(string);
                return Files.isDirectory(path, new LinkOption[0]);
            }

            @Override
            public void remove(String string) {
                Path path = this.path(string);
                Path path3 = Path.of(this.valueOf("root").asString(), new String[0]);
                if (!Files.exists(path, new LinkOption[0])) {
                    return;
                }
                if (Files.isRegularFile(path, new LinkOption[0])) {
                    try {
                        Files.delete(path);
                    }
                    catch (Exception exception) {
                        throw new RuntimeException(exception);
                    }
                }
                try (Stream<Path> stream = Files.walk(path, new FileVisitOption[0]);){
                    stream.filter(path2 -> !path2.equals(path3)).map(Path::toFile).sorted(Comparator.reverseOrder()).forEach(java.io.File::delete);
                }
                catch (Exception exception) {
                    throw new RuntimeException(exception);
                }
            }

            @Override
            public Collection<String> list(String string) {
                Path path2 = this.path(string);
                if (!Files.exists(path2, new LinkOption[0])) {
                    return Collections.emptyList();
                }
                String string2 = this.valueOf("root").asString();
                LinkedList<String> linkedList = new LinkedList<String>();
                if (Files.isRegularFile(path2, new LinkOption[0])) {
                    linkedList.add(Storage.relativize(string2, path2.toString()));
                } else {
                    try (Stream<Path> stream = Files.walk(path2, new FileVisitOption[0]);){
                        stream.filter(path -> Files.isRegularFile(path, new LinkOption[0])).forEach(path -> linkedList.add(Storage.relativize(string2, path.toString())));
                    }
                    catch (Exception exception) {
                        throw new RuntimeException(exception);
                    }
                }
                return linkedList;
            }

            @Override
            public Collection<String> tree(String string) {
                Path path = this.path(string);
                if (!Files.exists(path, new LinkOption[0])) {
                    return Collections.emptyList();
                }
                LinkedList<String> linkedList = new LinkedList<String>();
                if (Files.isRegularFile(path, new LinkOption[0])) {
                    return linkedList;
                }
                try (Stream<Path> stream = Files.list(path);){
                    stream.forEach(path2 -> {
                        if (Files.isRegularFile(path2, new LinkOption[0])) {
                            linkedList.add(Storage.relativize(path.toString(), path2.toString()));
                        } else {
                            linkedList.add(Storage.relativize(path.toString(), path2.toString()) + "/");
                        }
                    });
                }
                catch (Exception exception) {
                    throw new RuntimeException(exception);
                }
                return linkedList;
            }

            @Override
            public void clear() {
                Path path = Path.of(this.valueOf("root").asString(), new String[0]);
                try (Stream<Path> stream = Files.walk(path, new FileVisitOption[0]);){
                    stream.filter(path2 -> !path2.equals(path3)).map(Path::toFile).sorted(Comparator.reverseOrder()).forEach(java.io.File::delete);
                }
                catch (Exception exception) {
                    throw new RuntimeException(exception);
                }
            }
        }
    }

    public static abstract class Type
    extends Entity {
        public void put(String string, Data data) {
            this.put(string, data.toString());
        }

        public void put(String string, String string2) {
            this.put(string, string2.getBytes(StandardCharsets.UTF_8));
        }

        public abstract void put(String var1, byte[] var2);

        public abstract byte[] get(String var1);

        public String getString(String string) {
            byte[] byArray = this.get(string);
            return byArray == null ? null : new String(byArray, StandardCharsets.UTF_8);
        }

        public Data getData(String string) {
            String string2 = this.getString(string);
            return string2 == null ? null : Json.decode(this.getString(string));
        }

        public abstract boolean containsEntry(String var1);

        public abstract boolean containsPath(String var1);

        public abstract void remove(String var1);

        public abstract Collection<String> list(String var1);

        public abstract Collection<String> tree(String var1);

        public abstract void clear();

        public void drainTo(Type type) {
            this.drainTo("", type);
        }

        public void drainTo(String string, Type type) {
            for (String string2 : this.list(string)) {
                type.put(string2, this.get(string2));
            }
        }

        @Override
        public final String category() {
            return StringUtils.toLowerCase(Storage.class);
        }
    }
}

