/*
 * Decompiled with CFR 0.152.
 */
package aeonics.data;

import aeonics.data.Data;
import aeonics.util.Json;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Predicate;

public class DataMap
implements Data {
    private HashMap<String, Data> source = new HashMap();

    public DataMap(Map<?, ?> map) {
        if (map == null || map.isEmpty()) {
            return;
        }
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            this.source.put(entry.getKey() == null ? null : entry.getKey().toString(), Data.of(entry.getValue()));
        }
    }

    @Override
    public Iterator<Data> iterator() {
        return this.source.values().iterator();
    }

    @Override
    public Iterable<Map.Entry<String, Data>> entrySet() {
        return this.source.entrySet();
    }

    @Override
    public boolean isMap() {
        return true;
    }

    @Override
    public boolean isList() {
        return false;
    }

    @Override
    public boolean isBool() {
        return false;
    }

    @Override
    public boolean isNumber() {
        return false;
    }

    @Override
    public boolean isString() {
        return false;
    }

    @Override
    public boolean isNull() {
        return false;
    }

    @Override
    public boolean is(Class<?> clazz) {
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.source.isEmpty();
    }

    @Override
    public Data get(String string) {
        Data data = this.source.get(string);
        return data == null ? Data.of(null) : data;
    }

    @Override
    public Data get(int n) {
        return this.get("" + n);
    }

    @Override
    public <T> T get() {
        return (T)this;
    }

    @Override
    public boolean containsKey(String string) {
        return this.source.containsKey(string);
    }

    @Override
    public void clear() {
        this.source.clear();
    }

    @Override
    public int size() {
        return this.source.size();
    }

    @Override
    public Data remove(String string) {
        return this.source.remove(string);
    }

    @Override
    public Data remove(int n) {
        return this.remove("" + n);
    }

    @Override
    public Data remove(Data data) {
        this.source.values().remove(data);
        return data;
    }

    @Override
    public void removeIf(Predicate<Data> predicate) {
        this.source.values().removeIf(predicate);
    }

    @Override
    public Data add(Object object) {
        return this.put("", object);
    }

    @Override
    public Data add(Object ... objectArray) {
        for (int i = 0; i < objectArray.length; ++i) {
            String string = "" + objectArray[i];
            this.put(string, ++i < objectArray.length ? objectArray[i] : null);
        }
        return this;
    }

    @Override
    public Data put(String string, Object object) {
        if (object instanceof Data) {
            this.source.put(string, (Data)object);
        } else {
            this.source.put(string, Data.of(object));
        }
        return this;
    }

    @Override
    public Data set(int n, Object object) {
        return this.put("" + n, object);
    }

    @Override
    public Data set(Object object) {
        return this.put("", object);
    }

    @Override
    public boolean asBool() {
        return !this.source.isEmpty();
    }

    @Override
    public Number asNumber() {
        return this.source.size();
    }

    @Override
    public String asString() {
        return this.toString();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        this.toString(stringBuilder);
        return stringBuilder.toString();
    }

    @Override
    public void toString(StringBuilder stringBuilder) {
        stringBuilder.append("{");
        boolean bl = true;
        for (Map.Entry<String, Data> entry : this.source.entrySet()) {
            if (!bl) {
                stringBuilder.append(", ");
            }
            bl = false;
            stringBuilder.append("\"");
            if (entry.getKey() != null) {
                stringBuilder.append(Json.escape(entry.getKey()));
            }
            stringBuilder.append("\": ");
            if (entry.getValue() == null) {
                stringBuilder.append("null");
                continue;
            }
            entry.getValue().toString(stringBuilder);
        }
        stringBuilder.append("}");
    }

    public boolean equals(Object hashMap) {
        if (hashMap == this) {
            return true;
        }
        if (hashMap instanceof DataMap) {
            hashMap = ((DataMap)((Object)hashMap)).source;
        } else if (hashMap instanceof Data) {
            hashMap = ((Data)((Object)hashMap)).get();
        }
        if (hashMap == this.source) {
            return true;
        }
        if (hashMap == null) {
            return false;
        }
        if (!(hashMap instanceof Map)) {
            return false;
        }
        Map map = hashMap;
        if (this.source.size() != map.size()) {
            return false;
        }
        for (Map.Entry<String, Data> entry : this.source.entrySet()) {
            if (!map.containsKey(entry.getKey())) {
                return false;
            }
            if (entry.getValue().equals(map.get(entry.getKey()))) continue;
            return false;
        }
        return true;
    }

    @Override
    public Data clone() {
        DataMap dataMap = new DataMap(null);
        this.cloneTo(dataMap);
        return dataMap;
    }

    @Override
    public void cloneTo(Data data) {
        if (!(data instanceof DataMap)) {
            throw new IllegalArgumentException("Clone failed. Incompatible receiving data type.");
        }
        data.clear();
        for (Map.Entry<String, Data> entry : this.entrySet()) {
            data.put(entry.getKey(), entry.getValue().clone());
        }
    }
}

